import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.Description;
import org.uddi4j.datatype.Name;
import org.uddi4j.datatype.service.BusinessService;
import org.uddi4j.datatype.tmodel.TModel;
import org.uddi4j.response.AuthToken;
import org.uddi4j.response.BusinessInfo;
import org.uddi4j.response.BusinessInfos;
import org.uddi4j.response.BusinessList;
import org.uddi4j.response.ServiceDetail;
import org.uddi4j.response.ServiceInfo;
import org.uddi4j.response.ServiceInfos;
import org.uddi4j.response.ServiceList;
import org.uddi4j.transport.TransportFactory;
import org.uddi4j.util.CategoryBag;
import org.uddi4j.util.KeyedReference;
import java.security.Security;
import java.util.Vector;

public class UDDISaveService1 {

	public static void main(String[] args) throws Exception {

		System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");      
		Security.addProvider(new com.sun.net.ssl.internal.ssl.Provider());

		System.setProperty(TransportFactory.PROPERTY_NAME, "org.uddi4j.transport.ApacheAxisTransport");

		UDDIProxy proxy = new UDDIProxy();
		proxy.setInquiryURL("http://uddi.microsoft.com/inquire");
		proxy.setPublishURL("https://uddi.microsoft.com/publish");

		Vector names = new Vector();
		names.add(new Name("Services Web & compagnie"));
		BusinessList bl = proxy.find_business(names, null, null, null, null, null, 0);

		BusinessInfos bis = bl.getBusinessInfos();
		if (bis.size() == 0) {
			System.out.println("no business(es) found");
			System.exit(0);
		}

		AuthToken at = proxy.get_authToken("user", "password");

		System.out.println(bis.size()+" business(es) found\n");
		Vector biv = bis.getBusinessInfoVector();
		for (int i = 0; i < biv.size(); i++) {
			BusinessInfo bi = (BusinessInfo)biv.elementAt(i);
			System.out.println(bi.getNameString());
			System.out.println(bi.getBusinessKey());
			System.out.println("\n");

			BusinessService bs = new BusinessService("");
			names = new Vector();
			names.add(new Name("Mon API de recherche UDDI"));
			bs.setNameVector(names);
			bs.setBusinessKey(bi.getBusinessKey());

			Vector bsdsv = new Vector();
			Description bsd = new Description("Mon service d'API de recherche UDDI.");
			bsdsv.addElement(bsd);
			bs.setDescriptionVector(bsdsv);

			Vector cbv = new Vector();

			KeyedReference naics = new KeyedReference("Information", "51");
			naics.setTModelKey(TModel.NAICS_TMODEL_KEY);
			cbv.addElement(naics);
			naics = new KeyedReference("Information Services and Data Processing Services", "514");
			naics.setTModelKey(TModel.NAICS_TMODEL_KEY);
			cbv.addElement(naics);
			naics = new KeyedReference("Data Processing Services", "5142");
			naics.setTModelKey(TModel.NAICS_TMODEL_KEY);
			cbv.addElement(naics);

			KeyedReference unspsc = new KeyedReference("Communications and Computer Equipment and Peripherals and Components and Supplies", "43.00.00.00.00");
			unspsc.setTModelKey(TModel.UNSPSC_73_TMODEL_KEY);
			cbv.addElement(unspsc);
			unspsc = new KeyedReference("Internet and intranet software", "43.16.28.00.00");
			unspsc.setTModelKey(TModel.UNSPSC_73_TMODEL_KEY);
			cbv.addElement(unspsc);

			KeyedReference geo = new KeyedReference("France", "FR");
			geo.setTModelKey(TModel.ISO_CH_TMODEL_KEY);
			cbv.addElement(geo);
			geo = new KeyedReference("Ile-De-France", "FR-J");
			geo.setTModelKey(TModel.ISO_CH_TMODEL_KEY);
			cbv.addElement(geo);
			geo = new KeyedReference("Hauts-De-Seine", "FR-92");
			geo.setTModelKey(TModel.ISO_CH_TMODEL_KEY);
			cbv.addElement(geo);

			CategoryBag cb = new CategoryBag();
			cb.setKeyedReferenceVector(cbv);
			bs.setCategoryBag(cb);

			Vector services = new Vector();
			services.add(bs);
			ServiceDetail sd = proxy.save_service(at.getAuthInfoString(), services);
			System.out.println( "new service saved\n" );

			ServiceList sl = proxy.find_service(bi.getBusinessKey(), names, null, null, null, 0);

			ServiceInfos sis = sl.getServiceInfos();
			if (sis.size() == 0) {
				System.out.println("no service(s) found");
			}
			else {
				System.out.println(sis.size()+" service(s) found\n");
				Vector siv = sis.getServiceInfoVector();
				for (int j = 0; j < siv.size(); j++) {
					ServiceInfo si = (ServiceInfo)siv.elementAt(j);
					System.out.println(si.getNameString());
					System.out.println(si.getServiceKey());
					System.out.println("\n");
				}
			}
		}
		proxy.discard_authToken(at.getAuthInfo());
	}
}